#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

void print_vector(vector<int>& vector, int size) {
    for (int i = 0; i < size; i++) {
        cout << vector[i] << endl;
    }
}

void correct_vector(vector<int>& vector, int size) {
    if(size != 2 && vector[0] == vector[2] && vector[1] != vector[2]) {
        swap(vector[0], vector[1]);
    }
    for(int i = 1; i < size - 2; i += 2) {
        if(vector[i] != vector[i+1] && vector[i+1] != vector[i+2]) {
            swap(vector[i+1], vector[i+2]);
        }
    }
}

int check_happines(vector<int>& vector, int size) {
    int happines = 0;
    for(int i = 0; i < size-1; i++) {
        if(vector[i] == vector[i+1]) {
            happines++;
        }
    }
    
    return happines;
}

int main() {
    int T, broj;
    cin >> T;
    
    vector<int> happy_day;
    int T_brojac = T;
    while (T_brojac--) {
        int N;
        cin >> N;

        vector<int> A(2 * N);
        for (int i = 0; i < N; ++i) {
            cin >> broj;
            A[2 * i] = broj % 2;
        }
        
        for (int i = 1; i < N+1; ++i) {
            cin >> broj;
            A[2 * i - 1] = broj % 2;
        }
        
        correct_vector(A, 2 * N);
        int happines = check_happines(A, 2 * N);
        happy_day.push_back(happines);
    }

    print_vector(happy_day, T);
    return 0;
}